/* --------------------------------------------------------------
  ImageApi.js 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/


'use strict';

import Ajax from '../libs/Ajax';

export default {
	/**
	 * Upload the selected image file.
	 *
	 * @param {jQuery} $fileInput The file input element to be uploaded.
	 *
	 * @return {jQuery.jqXHR}
	 */
	upload($fileInput) {
		StyleEdit.Validator.isObject($fileInput);
		
		const files = $fileInput.get(0).files;
		
		if (files.length === 0) {
			throw new Error('No image files where selected for upload.');
		}
		
		const ajaxUrl = StyleEdit.Config.get('baseUrl') + '/api.php/templates/' + StyleEdit.Config.get('template')
			+ '/images' + (StyleEdit.Config.get('theme') ? '?theme' : '');
		
		$fileInput.fileupload({
			url: ajaxUrl,
			dataType: 'json',
			autoUpload: false,
			acceptFileTypes: /(\.|\/)(png|jpg|jpeg|gif|bmp)$/i
		});
		
		return $fileInput.fileupload('send', {files: files});
	},
	
	/**
	 * Delete existing image.
	 *
	 * @param {String} filename The filename to be removed (e.g. 'image.png').
	 *
	 * @return {jQuery.jqXHR}
	 */
	delete(filename) {
		StyleEdit.Validator.isString(filename);
		
		const ajaxUrl = StyleEdit.Config.get('baseUrl') + '/api.php/templates/' + StyleEdit.Config.get('template')
			+ '/images/' + encodeURIComponent(filename);
		
		return Ajax.delete(ajaxUrl, {theme: StyleEdit.Config.get('theme') || undefined});
	}
}